/*
 * If distributed as part of the Linux kernel, this code is licensed under the
 * terms of the GPL v2.
 *
 * Otherwise, the following license terms apply:
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1) Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2) Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3) The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef _DEV_PCI_FCUCOM_H_
#define	_DEV_PCI_FCUCOM_H_



/**** fcu用 **********************************************************/

/*
 * packet size
 */
#define FCUCMDSIZE			64			/* コマンドパケットサイズ */


/*
 * packet head
 */
#define FCU_PKT_FINISH		0			/* パケット継続情報:最終 */
#define FCU_PKT_CONTINUE	1			/* パケット継続情報:継続 */


/*
 * status size
 */
#define FCUSTATSIZE			128			/* ステータスエリアサイズ */


/*
 * ioctl(FIOCGETRDY)
 */
#define FCU_NOTREADY		0			/* FCUはレディでない */
#define FCU_READY			1			/* FCUはレディ */


/*
 * ioctl(FIOCGETSTAT/FIOCSETSTAT)
 */
#define FCU_STATUS_BUFSIZE	16			/* fcu_status バッファサイズ */

typedef struct fcu_status {
	u_long	offset;						/* エリア内オフセット */
	u_long	nbytes;						/* read/writeサイズ */
	u_char	buf[FCU_STATUS_BUFSIZE];	/* データバッファ */
} fcu_status_t;



/**** fcud用 *********************************************************/

/*
 * コマンド(read/write)
 */
#define FCUD_START			0			/* DMAスタートコマンド */
#define FCUD_ABORT			1			/* DMAアボートコマンド */
#define FCUD_RSP			2			/* DMAウェイトコマンド */


/*
 * DMAチャンネル(read/write)
 */
#define FCUD_CH_SCAN		0			/* (DMA1) SCAN -> FCU */
#define FCUD_CH_PLOT		1			/* (DMA2) PLOT <- FCU */
#define FCUD_CH_SEND		2			/* (DMA3) Data -> FCU */
#define FCUD_CH_RECV		3			/* (DMA4) Data <- FCU */
#define	FCUD_CH_MAX			4			/* チャンネルMAX数 */


/*
 * バイトレーン(write)
 */
#define FCUD_LANE_1234		0			/* byte値が一致(address保存) */
#define FCUD_LANE_3412		1			/* ? */
#define FCUD_LANE_2143		2			/* short値が一致 */
#define FCUD_LANE_4321		3			/* long値が一致 */


/*
 * メモリ種別(write)
 */
#define FCUD_MEM_PREMAP		0			/* pre map(フレームメモリ) */
#define FCUD_MEM_MMAP		1			/* mmapエリア */


/*
 * DMA状態ビット FDIOCDMASTAT (ioctl)
 */
#define FCUD_DMA1_BUSY	FBI_BIT_DMACTL_DMA1		/* DMA1 busy */
#define FCUD_DMA2_BUSY	FBI_BIT_DMACTL_DMA2		/* DMA2 busy */
#define FCUD_DMA3A_BUSY	FBI_BIT_DMACTL_DMA3A	/* DMA3A busy */
#define FCUD_DMA4A_BUSY	FBI_BIT_DMACTL_DMA4A	/* DMA4A busy */
#define FCUD_DMA3B_BUSY	FBI_BIT_DMACTL_DMA3B	/* DMA3B busy */
#define FCUD_DMA4B_BUSY	FBI_BIT_DMACTL_DMA4B	/* DMA4B busy */
#define FCUD_DMA3_EXIST	FBI_BIT_DMACTL_DMA3BUF	/* DMA3 buffer data exist */
#define FCUD_DMA3_FULL	FBI_BIT_DMACTL_DMA3FULL	/* DMA3 buffer data full */
#define FCUD_DMA4_EXIST	FBI_BIT_DMACTL_DMA4BUF	/* DMA4 buffer data exist */
#define FCUD_DMA4_FULL	FBI_BIT_DMACTL_DMA4FULL	/* DMA4 buffer data full */
#define FCUD_DMA1_FULL	FBI_BIT_DMACTL_DMA1RDY	/* DMA1 buffer data full */
#define FCUD_DMA2_FULL	FBI_BIT_DMACTL_DMA2RDY	/* DMA2 buffer data full */


/*
 * DMAコマンド構造体
 */
typedef struct fcud_cmd {
	u_short	command;			/* コマンド */
	u_short	dmach;				/* DMAチャンネル */
	u_short	bytelane;			/* バイトレーン */
	u_short	memkind;			/* メモリ種別 */
	u_long	offset;				/* スタートアドレス */
	u_long	width;				/* ライン長 */
	u_long	line;				/* ライン数 */
} fcud_cmd_t;

/*
 * ioctl(FIOCINTSET)
 */
#define FCUD_INTR_WRITE_PACKET_SCU		1			/* ライト(パケットSCU) */
#define FCUD_INTR_ACK_PACKET_FCU		2			/* ACK(パケットFCU) */
#define FCUD_INTR_FCU_RDY_CONF			3			/* FCUレディ確認 */

/*
 * ioctl(FIOCINTCONF)
 */
#define FCUD_INTR_WRITE_PACKET_FCU		1			/* ライト(パケットFCU) */
#define FCUD_INTR_ACK_PACKET_SCU		2			/* ACK(パケットSCU) */
#define FCUD_INTR_SCU_RDY_CONF			3			/* SCUレディ確認 */


/*
 * ioctl(FDIOCFIFOADDR)
 */
typedef struct fcud_fifoaddr {
	u_long	fin_h;				/* FCU IN  FIFO address high */
	u_long	fin_l;				/* FCU IN  FIFO address low  */
	u_long	fout_h;				/* FCU OUT FIFO address high */
	u_long	fout_l;				/* FCU OUT FIFO address low  */
} fcud_fifoaddr_t;

/*
 * ioctl(FIOCMIRRORCONF)
 */
typedef struct fcu_mirror_conf {
	u_char	device;						/*	00		：ミラーリング対象デバイス				*/
	u_char	direction;					/*	01		：ミラーリング方向						*/
	u_char	reserve_1[2];				/*	02-03	：Reserve								*/
	u_long	ddr_adr;					/*	04-07	：ミラーリング対象アドレス(DDR)			*/
	u_long	block_adr;					/*	08-0B	：ミラーリング対象ブロック(eMMC)、ミラーリング対象アドレス(NVRAM)	*/
	u_short	size;						/*	0C-0D	：ミラーリングサイズ					*//* ※NVRAM用				*/
	u_char	reserve_2[2];				/*	0E-0F	：Reserve								*/
} fcu_mirror_conf_t;

#define	MIRRORING_DEVICE_eMMC			0			/* ミラーリング対象デバイス：eMMC	*/
#define	MIRRORING_DEVICE_NVRAM			1			/* ミラーリング対象デバイス：NVRAM	*/
#define	MIRRORING_DIRECTION_DDRtoDEV	0			/* ミラーリング方向：DDR->Device	*/
#define	MIRRORING_DIRECTION_DEVtoDDR	1			/* ミラーリング方向：Device->DDR	*/

/*
 * ioctl(FIOCMIRRORRESP)
 */
typedef struct fcu_mirror_rsp {
	u_char	result;						/*	00		：ミラーリング結果						*/
	u_char	reserve_1[15];				/*	01-0F	：Reserve								*/
} fcu_mirror_rsp_t;

#define	MIRRORING_RESULT_NG			0			/* ミラーリング結果：NG		*/
#define	MIRRORING_RESULT_OK			1			/* ミラーリング結果：OK		*/

/*
 * ioctl(FIOCFCUACTIVE)
 */
#define FCUD_FCU_NOTACTIVE	0	/* FCU非動作中 */
#define FCUD_FCU_ACTIVE		1	/* FCU動作中 */


/*
 * ioctl(FDIOCFIFOWR/FDIOCFIFORD)
 * FCU検査治具用
 */
#define FCUD_FIFO_RDWR_SIZE	256		/* バッファサイズ */

typedef struct fcud_fifo_read_write {
	u_char	data[FCUD_FIFO_RDWR_SIZE];
} fcud_fifo_read_write_t;

/* 省エネ対応fcu(face3.5)定義 */
#define FBI35_DEV_ID	(0x00000264)		/* FACE3.5のデバイスID */
#define FBI35_REV_ID	(0x00000002)		/* FACE3.5のリビジョンID */

#define FBI_OFS_CONF_DEV_ID	(0x00)			/* デバイスID用オフセット */
#define FBI_OFS_CONF_REV_ID	(0x08)			/* リビジョンID用オフセット */

#define FBI_CONF_8BIT_MASK	(0x000000ff)	/* リビジョンIDマスク */
#define FBI_CONF_16BIT_MASK	(0x0000ffff)	/* デバイスID用マスク */

/*
 * ioctl
 */
/* fcu用 */
#define FIOCSETRDY		_IO  ('F', 1)
#define FIOCGETRDY		_IOR ('F', 2, u_long)
#define FIOCRESET		_IO  ('F', 3)
#define FIOCGETSTAT		_IOWR('F', 4, fcu_status_t)
#define FIOCSETSTAT		_IOWR('F', 5, fcu_status_t)
#define FIOCDEBUG		_IOW ('F', 20, int)
#define FIOCINTSET		_IOW  ('F', 31, u_char)
#define FIOCINTCONF		_IOR  ('F', 32, u_char)
#define FIOCMIRRORCONF	_IOR  ('F', 33, fcu_mirror_conf_t)
#define FIOCMIRRORRESP	_IOW  ('F', 34, fcu_mirror_rsp_t)
#define FIOCFCUACTIVE	_IOR  ('F', 41, int)

/* fcud用(+100) */
#define FDIOCSCANEND	_IO  ('F', 101)
#define FDIOCDMASTAT	_IOR ('F', 102, u_long)
#define FDIOCMAPSIZE	_IOR ('F', 103, u_long)
#define FDIOCFIFOADDR	_IOR ('F', 104, fcud_fifoaddr_t)
#define FDIOCDEBUG		_IOW ('F', 120, int)
#define FDIOCFBI2CHECK	_IO  ('F', 105)
/* fcud用(+200) - 検査治具 */
#define FDIOCFIFOWR		_IOW ('F', 200, fcud_fifo_read_write_t)
#define FDIOCFIFORD		_IOR ('F', 201, fcud_fifo_read_write_t)


#endif	/* !_DEV_PCI_FCUCOM_H_ */
